/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.casting.SpellList;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListIota
extends Iota {
    private final int depth;
    private final int size;
    public static IotaType<ListIota> TYPE = new IotaType<ListIota>(){

        @Override
        @Nullable
        public ListIota deserialize(class_2520 tag, class_3218 world) throws IllegalArgumentException {
            class_2499 listTag = (class_2499)HexUtils.downcast(tag, class_2499.field_21039);
            ArrayList<Iota> out = new ArrayList<Iota>(listTag.size());
            for (class_2520 sub : listTag) {
                class_2487 csub = (class_2487)HexUtils.downcast(sub, class_2487.field_21029);
                Iota subiota = IotaType.deserialize(csub, world);
                if (subiota == null) {
                    return null;
                }
                out.add(subiota);
            }
            return new ListIota(out);
        }

        @Override
        public class_2561 display(class_2520 tag) {
            class_5250 out = class_2561.method_43473();
            class_2499 list = (class_2499)HexUtils.downcast(tag, class_2499.field_21039);
            for (int i = 0; i < list.size(); ++i) {
                boolean alwaysShowCommas;
                class_2520 sub = list.method_10534(i);
                class_2487 csub = (class_2487)HexUtils.downcast(sub, class_2487.field_21029);
                out.method_10852(IotaType.getDisplay(csub));
                if (i >= list.size() - 1) continue;
                boolean thisIotaNeedsComma = IotaType.getTypeFromTag(csub) != PatternIota.TYPE;
                boolean nextIotaNeedsComma = IotaType.getTypeFromTag((class_2487)HexUtils.downcast(list.method_10534(i + 1), class_2487.field_21029)) != PatternIota.TYPE;
                boolean bl = alwaysShowCommas = HexConfig.client() != null && HexConfig.client().alwaysShowListCommas();
                if (!thisIotaNeedsComma && !nextIotaNeedsComma && !alwaysShowCommas) continue;
                out.method_27693(", ");
            }
            return class_2561.method_43469((String)"hexcasting.tooltip.list_contents", (Object[])new Object[]{out}).method_27692(class_124.field_1064);
        }

        @Override
        public int color() {
            return -5635926;
        }
    };

    public ListIota(@NotNull SpellList list) {
        super(HexIotaTypes.LIST, list);
        int maxChildDepth = 0;
        int totalSize = 1;
        for (Iota iota : list) {
            totalSize += iota.size();
            maxChildDepth = Math.max(maxChildDepth, iota.depth());
        }
        this.depth = maxChildDepth + 1;
        this.size = totalSize;
    }

    public ListIota(@NotNull List<Iota> list) {
        this(new SpellList.LList(list));
    }

    public SpellList getList() {
        return (SpellList)this.payload;
    }

    @Override
    public boolean isTruthy() {
        return this.getList().getNonEmpty();
    }

    @Override
    public boolean toleratesOther(Iota that) {
        Iota y;
        Iota x;
        if (!ListIota.typesMatch(this, that)) {
            return false;
        }
        SpellList a = this.getList();
        if (!(that instanceof ListIota)) {
            return false;
        }
        ListIota list = (ListIota)that;
        SpellList b = list.getList();
        SpellList.SpellListIterator aIter = a.iterator();
        SpellList.SpellListIterator bIter = b.iterator();
        do {
            if (!aIter.hasNext() && !bIter.hasNext()) {
                return true;
            }
            if (aIter.hasNext() == bIter.hasNext()) continue;
            return false;
        } while (Iota.tolerates(x = aIter.next(), y = bIter.next()));
        return false;
    }

    @Override
    @NotNull
    public class_2520 serialize() {
        class_2499 out = new class_2499();
        for (Iota subdatum : this.getList()) {
            out.add((Object)IotaType.serialize(subdatum));
        }
        return out;
    }

    @Override
    @Nullable
    public Iterable<Iota> subIotas() {
        return this.getList();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int depth() {
        return this.depth;
    }
}

